<?php

/**
 * @link https://www.humhub.org/
 * @copyright Copyright (c) 2015 HumHub GmbH & Co. KG
 * @license https://www.humhub.com/licences
 */

namespace humhub\modules\user\models\fieldtype;

use humhub\modules\user\models\Profile;
use humhub\modules\user\models\User;
use Yii;

/**
 * ProfileFieldTypeTextArea handles text area profile fields.
 *
 * @package humhub.modules_core.user.models
 * @since 0.5
 */
class TextArea extends BaseType
{
    /**
     * @inheritdoc
     */
    public $type = 'textarea';

    /**
     * Returns Form Definition for edit/create this field.
     *
     * @return array Form Definition
     */
    public function getFormDefinition($definition = [])
    {
        return parent::getFormDefinition([
            static::class => [
                'type' => 'form',
                'title' => Yii::t('UserModule.profile', 'Text area field options'),
                'elements' => [
                ],
            ]]);
    }

    /**
     * Saves this Profile Field Type
     */
    public function save()
    {
        $columnName = $this->profileField->internal_name;
        if (!Profile::columnExists($columnName)) {
            $query = Yii::$app->db->getQueryBuilder()->addColumn(Profile::tableName(), $columnName, 'TEXT');
            Yii::$app->db->createCommand($query)->execute();
        }

        return parent::save();
    }

    /**
     * @inheritdoc
     */
    public function getFieldRules($rules = [])
    {
        $rules[] = [$this->profileField->internal_name, 'safe'];

        return parent::getFieldRules($rules);
    }

    /**
     * @inheritdoc
     */
    public function getFieldFormDefinition(?User $user = null, array $options = []): array
    {
        return parent::getFieldFormDefinition($user, array_merge([
            'rows' => '3',
        ], $options));
    }

    public function getUserValue(User $user, bool $raw = true, bool $encode = true): ?string
    {
        $value = parent::getUserValue($user, $raw, $encode);
        return $encode ? nl2br($value) : $value;
    }

}
